/*
*  Object %name    : %
*  State           :  %state%
*  Creation date   :  Mon Mar 28 12:09:38 2005
*  Last modified   :  %modify_time%
*/
/** @file
*  \brief A brief description of this module
*
*  \version SST_TST_ATP_Utility.c#1:csrc:1
*  \author Sagitb
*  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************* Include Files ***********************************/
/************* Include Files ***********************************/
#include "SST_TST.h"
/************************ Defines ******************************/
#define UTIL_TEST_NAME "ATP test SST Utility"
#define UTIL_DATA_SIZE 3
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
/************* Private function prototype **********************/
/************************ Public Functions *********************/
/****************************************************************
* Function Name:
*  SST_TST_ATP_UtilitySize
*
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the handle build and handle type retrieval
*
* Algorithm:
* 1.  Terminate the SST.
* 2.  Init the SST for operations.
* 3.  Create a session for operations.
* 4.  Open a transaction for operations.
* 5.  Call SST_UtilNVSSizesGet with the MainDB handle.
* 6   Call SST_UtilNVSSizesGet with the TST_SecondaryDB handle.
* 7.  Call SST_UtilNVSMaxSizeSet of the MainDB with 1000 + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES. 
* 8.  Call SST_UtilNVSMaxSizeSet of the SecondaryDB with 1000 + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES.
* 9.  Call SST_UtilNVSMaxSizeSet with a DB size smaller then the DB used size, should fail.
* 10. Call SST_UtilNVSMaxSizeSet with a DB size larger then the max DB  size, should fail.
* 11. Call SST_UtilNVSMaxSizeSet with an invalid handle, should fail.
* 12. Call SST_UtilNVSMaxSizeSet with size that is smaller from max size but bigger from currant size.
* 13. Call SST_UtilNVSSizesGet of the main DB and check that the max size equals to the one entered 
      in the previous operation.
* 14. Call SST_UtilNVSSizesGet of the Secondary DB and validate the max size did not change.
* 15. Call SST_DataInsert with data element that will exceed the current max database size, should fail.
* 16. Create a new  password authenticator
* 17. Close the transaction.
* 18. Open the  password authentication
* 19. Open a transaction for operations
* 18. Open the  password authentication.
* 19. Open a transaction for operations.
* 20. SST_DataInsert with data size 2 (fail .
* 21. Close the transaction.
* 22. Open a transaction for operations.
* 23. Increase the max size of the DB.
* 24. Call SST_DataInsert with data element again.
* 25. Modify the data.
* 26. Call Transaction Rollback.
* 27. Open a transaction for operations.
* 28. insert a new Data object.
* 29.  Delete the data.
* 30. insert 6 data objects the 6 should fail.
* 31. SST_UtilNVSSizesGet - Main
* 32. Set max size - Main.
* 33. SST_DataInsert.
* 34. SST_DataInsert with data size 2 (fail)
* 35.delete the data objects
* 36. get Transaction file max size
* 37. Call SST_UtilNVSMaxSizeSet - increase max size - Transaction file
* 38.insert 5 data objects
* 39.delete the data objects
* 40.Set the max Size of both DB to 0x7ffffff0
* 41. Delete the pass Authenticator
* 42. Close the transaction
* 43.Delete the session
********************************************************************************/
DxError_t SST_TST_ATP_UtilitySize ( void )
{
    /********* TST Variables initialization *********/
    SSTTxnId_t         TST_TransactionId;
    SSTSessionId_t     TST_SessionId;
    SSTDataType_t      TST_aDataType;
    SSTHandle_t        TST_aDataHandle;
    DxByte_t           TST_Data[20]; 
    DxUint32_t         TST_DataSize = 20;
    SSTHandle_t        TST_InitialCtrlAuth, TST_PasswordAuthHandle;
    DxUint32_t         TST_maxSizeInBytesMain, TST_maxSizeInBytesMainIn; 
    DxUint32_t         TST_usedSizeInBytesMain;
    DxUint32_t         TST_maxSizeInBytesTxn,  TST_maxSizeInBytesTxnIn;
    DxUint32_t         TST_usedSizeInBytesTxn;
    DxUint32_t         TST_CurrUsedSizeInBytesMain,TST_CurrUsedSizeInBytesTxnLast, TST_NewUsedSizeInBytesMain;
    DxUint32_t         i;
    DxChar             * TestName = "ATP test SST Utility Size";  
    DxError_t          TST_Status = DX_FAILURE;
    int dataSize = 256;       


    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** SST_TST_ATP_UtilitySize Tests ******************* \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    /*1. create a new database*/

    /* 1.Terminate the SST */
    /*-------------------*/
    TST_Status = SST_Terminate();

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"1.  SST_Terminate",
                                          TestName,
                                          TestName);


        /*open files and get files handle*/
#ifndef DX_NVS_RAM

    TST_Status =DX_VOS_FClose(TST_MainDBFileHandle);
     if (TST_Status == DX_FAILURE)
     {
       DX_VOS_Printf("CANT CLOSE MAIN FILE \n");
       return TESTFAIL;
     }
     
     TST_Status = DX_VOS_FOpen(&TST_MainDBFileHandle,SST_DB_FILENAME ,"w+b");
     if (TST_Status == DX_FAILURE)
     {
       DX_VOS_Printf("CANT OPEN MAIN FILE \n");
       return TESTFAIL;
     }

     TST_Status =DX_VOS_FClose(TST_SecondaryDBFileHandle);
     if (TST_Status == DX_FAILURE)
     {
       DX_VOS_Printf("CANT CLOSE SECONDARY FILE \n");
       return TESTFAIL;
     }

    TST_Status = DX_VOS_FOpen(&TST_SecondaryDBFileHandle,SST_DB_FILENAME_SECOND ,"w+b");
    if (TST_Status == DX_FAILURE)
    {
     DX_VOS_Printf("CANT OPEN SECONDARY FILE \n");
     return TESTFAIL;
    }
#else
         DX_VOS_MemSetZero(TST_MainDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
         DX_VOS_MemSetZero(TST_SecondaryDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
          
#endif
    /* 2.Init the SST for operations */
    /*-------------------------------*/
    TST_Status = SST_Init((DxNvsMemoryId_t)TST_MainDBFileHandle,
                         (DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                          DX_NULL,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"2.  SST_Init",
                                          TestName,
                                          TestName);


    TST_aDataType = 0x33;
    TST_aDataHandle.objId = 0x4455;
    

    /* 3.Create a session for operations */
    /*-----------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"3.  SST_SessionCreate",
                                          TestName,
                                          TestName);


    /*4. Open a transaction for operations */
    /*-------------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"4.  SST_TransactionStart",
                                          TestName,
                                          TestName);
   
    
    /* 5.Call SST_UtilNVSSizesGet with the MainDB handle*/
    /*--------------------------------------------------*/
    TST_Status = SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_MainDBFileHandle,
                                    &TST_maxSizeInBytesMain,
                                    &TST_CurrUsedSizeInBytesMain);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"5.  SST_UtilNVSSizesGet - TST_MainDBFileHandle",
                                          TestName,
                                          TestName);


    /* 6.Call SST_UtilNVSSizesGet with the TST_SecondaryDB handle*/
    /*-----------------------------------------------------------*/
    TST_Status = SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                                    &TST_maxSizeInBytesTxn,
                                    &TST_CurrUsedSizeInBytesTxnLast);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"6.  SST_UtilNVSSizesGet - TST_SecondaryDBFileHandle",
                                          TestName,
                                          TestName);


    TST_NewUsedSizeInBytesMain =1000;
    TST_maxSizeInBytesMainIn =TST_NewUsedSizeInBytesMain + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES;
    TST_maxSizeInBytesTxnIn = 1000 + SST_NVS_TXN_OVERHEAD_SIZE_IN_BYTES;
   
    /* 7. Call SST_UtilNVSMaxSizeSet of the MainDB with 1000 + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES  */
    /*----------------------------------------------------------------------------------------------*/
    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,TST_maxSizeInBytesMainIn);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"7.  SST_UtilNVSMaxSizeSet - TST_MainDBFileHandle - 1000 + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES",
                                          TestName,
                                          TestName);


    /* 8. Call SST_UtilNVSMaxSizeSet of the SecondaryDB with 1000 + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES */
    /*---------------------------------------------------------------------------------------*/
    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_SecondaryDBFileHandle,TST_maxSizeInBytesTxnIn);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"8.  SST_UtilNVSMaxSizeSet - TST_SecondaryDBFileHandle - 1000 + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES",
                                          TestName,
                                          TestName);



    /*9. Call SST_UtilNVSMaxSizeSet with a DB size smaller then the used DB actual size, should fail*/
    /*----------------------------------------------------------------------------------------------*/
    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,(TST_CurrUsedSizeInBytesMain/2));
    if(TST_Status == SST_RC_ERROR_NVS_MAX_SIZE_TOO_SMALL)
      TST_Status = TESTPASS;
    else 
      TST_Status = TESTFAIL;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"9.  SST_UtilNVSMaxSizeSet - TST_MainDBFileHandle - TST_CurrUsedSizeInBytesMain/2 (fail)",
                                          TestName,
                                          TestName);


    /*10. Call SST_UtilNVSMaxSizeSet with a DB size larger then the max DB  size, should fail*/
    /*--------------------------------------------------------------------------------------*/
    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,0x80000000);
    if(TST_Status == SST_RC_ERROR_NVS_MAX_SIZE_TOO_BIG)
      TST_Status = TESTPASS;
    else 
      TST_Status = TESTFAIL;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"10. SST_UtilNVSMaxSizeSet - TST_MainDBFileHandle - 0x80000000 (fail)",
                                          TestName,
                                          TestName);

   
    /*11. Call SST_UtilNVSMaxSizeSet with an invalid handle, should fail*/
    /*------------------------------------------------------------------*/
    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle+1,0x10000);

    if(TST_Status == SST_RC_ERROR_WRONG_MEMORY_ID)
      TST_Status = TESTPASS;
     else 
      TST_Status = TESTFAIL;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"11. SST_UtilNVSMaxSizeSet - TST_MainDBFileHandle - TST_MainDBFileHandle+1 (fail)",
                                          TestName,
                                          TestName);


    /*12. Call SST_UtilNVSMaxSizeSet with size that is smaller from max size but bigger from currant size*/
    /*---------------------------------------------------------------------------------------------------*/

    TST_Status = SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_MainDBFileHandle,
                                    &TST_maxSizeInBytesMain,
                                    &TST_usedSizeInBytesMain);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"12. SST_UtilNVSSizesGet ",
                                          TestName,
                                          TestName);

   
    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,
                                      TST_usedSizeInBytesMain + 2*SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"12. SST_UtilNVSMaxSizeSet + 2*(7*1024) ",
                                          TestName,
                                          TestName);
 

    /* align with the max set we just did: */
    TST_maxSizeInBytesMain = TST_usedSizeInBytesMain + 2*SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES;

    TST_maxSizeInBytesMainIn = (TST_usedSizeInBytesMain+TST_maxSizeInBytesMain)/2;

    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,
                                       TST_maxSizeInBytesMainIn);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"12. Call SST_UtilNVSMaxSizeSet with size that is smaller from max size but bigger from currant size ",
                                          TestName,
                                          TestName);



    /*13. Call SST_UtilNVSSizesGet of the main DB and check that the max size equals to the one entered 
    in the previous operation */
    /*------------------------------------------------------------------------------------------------*/
    TST_Status = SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_MainDBFileHandle,
                                    &TST_maxSizeInBytesMain,
                                    &TST_usedSizeInBytesMain);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"13. SST_UtilNVSSizesGet - TST_MainDBFileHandle",
                                          TestName,
                                          TestName);


    if(TST_maxSizeInBytesMain != TST_maxSizeInBytesMainIn)
      TST_Status = TESTFAIL;
    else 
      TST_Status = TESTPASS;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"13. Compare TST_maxSizeInBytesMain with  TST_maxSizeInBytesMainIn ",
                                          TestName,
                                          TestName);


    /*14.Call SST_UtilNVSSizesGet of the Secondary DB and validate the max size did not change*/
    /*----------------------------------------------------------------------------------------*/
    TST_Status = SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                                    &TST_maxSizeInBytesTxn,
                                    &TST_usedSizeInBytesTxn);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"14. SST_UtilNVSSizesGet TST_SecondaryDBFileHandle",
                                          TestName,
                                          TestName);



    if(TST_SST_BLOCK_ROUNDED_UP_SIZE(TST_maxSizeInBytesTxnIn) !=TST_maxSizeInBytesTxn)
      TST_Status = TESTFAIL;
    else 
      TST_Status = TESTPASS;


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"14. Compare TST_maxSizeInBytesTxnIn with  TST_maxSizeInBytesTxn",
                                          TestName,
                                          TestName);


    /*15.Call SST_DataInsert with data element that will exceed the current max database size, should fail*/
    /*----------------------------------------------------------------------------------------------------*/
    TST_DataSize = 2;
    
    
    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,
                                       TST_usedSizeInBytesMain
                                            +TST_DataSize + 80
                                            +SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES -1);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"15. SST_UtilNVSMaxSizeSet - used + data size + overhead - 1 ",
                                          TestName,
                                          TestName);


    /* 16.Create a new  password authenticator */
      /*--------------------------------------*/
      TST_InitialCtrlAuth.objDigest = 0;
      TST_InitialCtrlAuth.objId = SST_CLOSE_AUTH_HANDLE;
      TST_PasswordAuthHandle.objDigest = 0;
      TST_PasswordAuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
      TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                   TST_SessionId, 
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterMaxNumOfTrials,
                                                   TST_InitialCtrlAuth,
                                                   &TST_PasswordAuthHandle,
                                                   TST_Workspace,
                                                   TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"16 SST_AuthenticatorPasswordCreate ",
                                 TestName,
                                 TestName);


      /*17. Close the transaction */
      /*-----------------------*/
      TST_Status = SST_TransactionEnd(TST_TransactionId, DX_TRUE, TST_Workspace, TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"17. SST_TransactionEnd",
                                 TestName,
                                 TestName);


      /*18 Open the  password authentication */
      /*-------------------------------------*/
      TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                          TST_PasswordAuthHandle,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                          TST_NO_CHALLENGE,
                                          TST_Workspace,
                                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"18. SST_AuthenticationOpen ",
                                 TestName,
                                 TestName);


      /* 19 Open a transaction for operations */
      /*-----------------------------------*/
      TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"19.SST_TransactionStart",
                                 TestName,
                                 TestName);




  /*20. SST_DataInsert with data size 2 (fail)*/
    TST_Status = SST_DataInsert(TST_TransactionId,
                               TST_SessionId,
                               TST_PasswordAuthHandle,
                               TST_Data,
                               TST_DataSize,
                               DX_TRUE,
                               TST_aDataType,
                               &TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    if(TST_Status == SST_RC_ERROR_NVS_MAIN_MAX_SIZE_EXCEEDED ||SST_RC_ERROR_NVS_TXN_MAX_SIZE_EXCEEDED)
      TST_Status = TESTPASS;
    else 
      TST_Status = TESTFAIL;


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"20. SST_DataInsert with data size 2 (fail) ",
                                          TestName,
                                          TestName);


    /*21. Close the transaction */
    /*--------------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                   DX_TRUE,/*reflash sensitive*/
                                   TST_Workspace,
                                   TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"21. SST_TransactionEnd",
                                          TestName,
                                          TestName);


    /*22. Open a transaction for operations */
    /*-------------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"22. SST_TransactionStart",
                                          TestName,
                                          TestName);


   

    /*23.Increase the max size of the DB */
    /*-----------------------------------*/
    TST_maxSizeInBytesMainIn =  120000;
   
    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,TST_maxSizeInBytesMainIn);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"23. SST_UtilNVSMaxSizeSet - TST_MainDBFileHandle -  120000",
                                          TestName,
                                          TestName);


    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_SecondaryDBFileHandle,TST_maxSizeInBytesMainIn);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"23. SST_UtilNVSMaxSizeSet - TST_SecondaryDBFileHandle - 120000 ",
                                          TestName,
                                          TestName);


    /*24.Call SST_DataInsert with data element again*/
    /*----------------------------------------------*/
    TST_Status = SST_DataInsert(TST_TransactionId,
                               TST_SessionId,
                               TST_PasswordAuthHandle,
                               TST_Data,
                               TST_DataSize,
                               DX_TRUE,
                               TST_aDataType,
                               &TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"24. SST_DataInsert Call SST_DataInsert with data element size 2 ",
                                          TestName,
                                          TestName);


    /*25. Modify the data*/
    /*-------------------*/
    TST_Status = SST_DataModify(TST_TransactionId,
                               TST_SessionId,
                               TST_aDataHandle,
                               TST_Data,
                               TST_DataSize,
                               TST_DataSize - 1,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"25. SST_DataModify",
                                          TestName,
                                          TestName);



    /*26 Call Transaction Rollback*/
    /*----------------------------*/
    TST_Status = SST_TransactionRollback(TST_TransactionId,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"26. SST_TransactionRollback",
                                          TestName,
                                          TestName);
 


    /*.27 Open a transaction for operations */
    /*-------------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"27. SST_TransactionStart",
                                          TestName,
                                          TestName);


    /*28. Insert a new Data object */
    /*-----------------------------*/
     TST_Status = SST_DataInsert(TST_TransactionId,
                                 TST_SessionId,
                                 TST_PasswordAuthHandle,
                                 TST_Data,
                                 TST_DataSize,
                                 DX_TRUE,
                                 TST_aDataType,
                                 &TST_aDataHandle,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"28. SST_DataInsert",
                                          TestName,
                                          TestName);


    /*29 Delete the data*/
    /*-----------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                               TST_SessionId,
                               TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"29. SST_DataDelete",
                                          TestName,
                                          TestName);


     

   /*30.insert 6 data objects the 6 should fail*/
   /*------------------------------------------*/                          
    dataSize = 16;
   for(i = 0; i< 5 ; i++)
   {
    TST_aDataHandle.objId = i;

    
    /*31.SST_UtilNVSSizesGet - Main */ 
    TST_Status = SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_MainDBFileHandle,
                                    &TST_maxSizeInBytesMain,
                                    &TST_CurrUsedSizeInBytesMain);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"31. SST_UtilNVSSizesGet - Main",
                                          TestName,
                                          TestName);        

    
    /*32  Set max size - Main*/
    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,
                                      (TST_CurrUsedSizeInBytesMain + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES + dataSize));
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"32. SST_UtilNVSMaxSizeSet - Main",
                                          TestName,
                                          TestName); 
    
    /*33. SST_DataInsert*/
    TST_Status = SST_DataInsert(TST_TransactionId,
                               TST_SessionId,
                               TST_PasswordAuthHandle,
                               TST_Data,
                               TST_DataSize,
                               DX_TRUE,
                               0,
                               &TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"33. SST_DataInsert",
                                          TestName,
                                          TestName);

   }
  
   TST_aDataHandle.objId =5;
   /*34. SST_DataInsert with data size 2 (fail*/
   TST_Status = SST_DataInsert(TST_TransactionId,
                              TST_SessionId,
                              TST_PasswordAuthHandle,
                              TST_Data,
                              TST_DataSize,
                              DX_TRUE,
                              0,
                              &TST_aDataHandle,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

   if(TST_Status == SST_RC_ERROR_NVS_MAIN_MAX_SIZE_EXCEEDED)
       TST_Status = TESTPASS;
   else 
       TST_Status = TESTFAIL;


   TST_ATP_CHECK_ERROR_RETURN(TST_Status,"34. SST_DataInsert with data size 2 (fail) ",
                                         TestName,
                                         TestName);

  
   /*35.delete the data objects*/
   /*--------------------------*/
   for(i = 0; i< 5 ; i++)
   {
     TST_aDataHandle.objId = i;

     TST_Status = SST_DataDelete(TST_TransactionId,
                                 TST_SessionId,
                                 TST_aDataHandle,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"35. SST_DataDelete", TestName, TestName);
   }

    /*36. get Transaction file max size*/
    TST_Status = SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                                    &TST_maxSizeInBytesTxn,
                                    &TST_usedSizeInBytesTxn);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"36. SST_UtilNVSSizesGet get txn file max size",
                                          TestName,
                                          TestName);

    /*37. Call SST_UtilNVSMaxSizeSet - increase max size - Transaction file*/
    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_SecondaryDBFileHandle,TST_maxSizeInBytesTxn+ 60257);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"37. SST_UtilNVSMaxSizeSet - increase max size - Transaction file",
                                          TestName,
                                          TestName); 


   /*38.insert 5 data objects*/
   /*------------------------*/
   for(i = 0; i< 5 ; i++)
   {
    TST_aDataHandle.objId = i;
    TST_Status = SST_DataInsert(TST_TransactionId,
                               TST_SessionId,
                               TST_PasswordAuthHandle,
                               TST_Data,
                               TST_DataSize,
                               DX_TRUE,
                               0,
                               &TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"38. SST_DataInsert",
                                          TestName,
                                          TestName);

   }


   /*39.delete the data objects*/
   /*--------------------------*/
   for(i = 0; i< 5 ; i++)
   {
       TST_aDataHandle.objId = i;

       TST_Status = SST_DataDelete(TST_TransactionId,
                                 TST_SessionId,
                                 TST_aDataHandle,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"39. SST_DataDelete",
                                             TestName,
                                             TestName);

   }   
      
    /*40.Set the max Size of both DB to 0x7ffffff0*/
    /*--------------------------------------------*/

    TST_maxSizeInBytesMainIn = 0x7ffffff0;

    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,TST_maxSizeInBytesMainIn);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"40. SST_UtilNVSMaxSizeSet - TST_MainDBFileHandle -  0x7ffffff0",
                                          TestName,
                                          TestName);



    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_SecondaryDBFileHandle,TST_maxSizeInBytesMainIn);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"40. SST_UtilNVSMaxSizeSet - TST_SecondaryDBFileHandle -  0x7ffffff0",
                                          TestName,
                                          TestName);


    /*41. Delete the pass Authenticator*/
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,TST_PasswordAuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"41.SST_AuthenticatorDelete", TestName, TestName);




    /*42. Close the transaction */
    /*--------------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"42. SST_TransactionEnd",
                                          TestName,
                                          TestName);

    /* 43.Delete the session */
    /*-----------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"43. SST_SessionDelete",
                                          TestName,
                                          TestName);



   return TST_Status;

   EXIT_ON_ERROR:
    return DX_FAILURE;

}

/****************************************************************
* Function Name:
*  SST_TST_ATP_UtilitySizeWithKeys
*
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the utility size function wit
*
* Algorithm:
* 1.  Terminate the SST.
* 2.  Init the SST for operations.
* 3.  Create a session for operations.
* 4.  Open a transaction for operations.
* 5.  Call SST_UtilNVSSizesGet with the MainDB handle.
* 6   Call SST_UtilNVSSizesGet with the TST_SecondaryDB handle.
* 7.  Create a new  password authenticator
* 8. Close the transaction
* 9. Open the  password authentication
* 10. Open a transaction for operations
* 11. Get current size and set MainFile to AES key size + overhead + current
*     Insert AES key -> generate AES key (fail) -> delete AES key from DB ->
*     Generate AES Key (This test to check deleted list)
* 11.a Get current - Main
* 11.b Set max size - Main
* 11.c Insert first AES Key
* 11.d Generate AES key (fail)
* 11.e delete AES key
* 11.f generate AES key
* 12. Get current size and set MainFile to AES key size + overhead + current
*     Insert AES key -> Insert AES key (fail) -> delete AES key from DB ->
*     Insert AES key (This test to check deleted list)
* 12.a Get current - Main
* 12.b Set max size - Main
* 12.c Insert first AES Key 
* 12.d Insert second AES Key (fail)
* 12.e delete AES key
* 12.f Insert AES key
* 13. Set the max Size of both DB to 0x7ffffff0
* 14. Close the transaction.
* 15. Delete the session.
********************************************************************************/
DxError_t SST_TST_ATP_UtilitySizeWithKeys ( void )
{
    /********* TST Variables initialization *********/
    SSTTxnId_t         TST_TransactionId;
    SSTSessionId_t     TST_SessionId;
    SSTHandle_t        TST_InitialCtrlAuth,TST_PasswordAuthHandle;
    DxUint32_t         TST_maxSizeInBytesMain, TST_maxSizeInBytesMainIn; 
    DxUint32_t         TST_maxSizeInBytesTxn;
    DxUint32_t         TST_CurrUsedSizeInBytesMain,TST_CurrUsedSizeInBytesTxnLast, TST_NewUsedSizeInBytesMain;
    DxUint32_t         i;
    DxChar             * TestName = "ATP test SST Utility Size";    
    DxByte_t buf[1024];
    SSTDataType_t      TST_AESKeyDataType = TST_AESKEY_OBJECT;
    SSTHandle_t        KeyHandle;
    int keyDataSize[4] = {(16+4),(24+4),(32+4),(64+4)};    
    int k = 50;    
  DxError_t       TST_Status = DX_FAILURE;


    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** SST_TST_ATP_UtilitySize Tests ******************* \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    /*1. cretae a new database*/

    /* 1.Terminate the SST */
    /*-------------------*/
    TST_Status = SST_Terminate();

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"1.  SST_Terminate",
                                          TestName,
                                          TestName);


        /*open files and get files handle*/
#ifndef DX_NVS_RAM

    TST_Status =DX_VOS_FClose(TST_MainDBFileHandle);
     if (TST_Status == DX_FAILURE)
     {
       DX_VOS_Printf("CANT CLOSE MAIN FILE \n");
       return TESTFAIL;
     }
     
     TST_Status = DX_VOS_FOpen(&TST_MainDBFileHandle,SST_DB_FILENAME ,"w+b");
     if (TST_Status == DX_FAILURE)
     {
       DX_VOS_Printf("CANT OPEN MAIN FILE \n");
       return TESTFAIL;
     }

     TST_Status =DX_VOS_FClose(TST_SecondaryDBFileHandle);
     if (TST_Status == DX_FAILURE)
     {
       DX_VOS_Printf("CANT CLOSE SECONDARY FILE \n");
       return TESTFAIL;
     }

    TST_Status = DX_VOS_FOpen(&TST_SecondaryDBFileHandle,SST_DB_FILENAME_SECOND ,"w+b");
    if (TST_Status == DX_FAILURE)
    {
     DX_VOS_Printf("CANT OPEN SECONDARY FILE \n");
     return TESTFAIL;
    }
#else
         DX_VOS_MemSetZero(TST_MainDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
         DX_VOS_MemSetZero(TST_SecondaryDBPool,NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES);
          
#endif



    /* 2.Init the SST for operations */
    /*-----------------------------------*/
    TST_Status = SST_Init((DxNvsMemoryId_t)TST_MainDBFileHandle,
                         (DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                          DX_NULL,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"2.  SST_Init",
                                          TestName,
                                          TestName);


   
    /* 3.Create a session for operations */
    /*-----------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"3.  SST_SessionCreate",
                                          TestName,
                                          TestName);


    /*4. Open a transaction for operations */
    /*-------------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"4.  SST_TransactionStart",
                                          TestName,
                                          TestName);
       
    
    /* 5.Call SST_UtilNVSSizesGet with the MainDB handle*/
    /*--------------------------------------------------*/
    TST_Status = SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_MainDBFileHandle,
                                    &TST_maxSizeInBytesMain,
                                    &TST_CurrUsedSizeInBytesMain);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"5.  SST_UtilNVSSizesGet - TST_MainDBFileHandle",
                                          TestName,
                                          TestName);


    /* 6.Call SST_UtilNVSSizesGet with the TST_SecondaryDB handle*/
    /*-----------------------------------------------------------*/
    TST_Status = SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_SecondaryDBFileHandle,
                                    &TST_maxSizeInBytesTxn,
                                    &TST_CurrUsedSizeInBytesTxnLast);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"6.  SST_UtilNVSSizesGet - TST_SecondaryDBFileHandle",
                                          TestName,
                                          TestName);

        


      /* 7.Create a new  password authenticator */
      /*--------------------------------------*/
      TST_InitialCtrlAuth.objDigest = 0;
      TST_InitialCtrlAuth.objId = SST_CLOSE_AUTH_HANDLE;
      TST_PasswordAuthHandle.objDigest = 0;
      TST_PasswordAuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
      TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                   TST_SessionId, 
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterMaxNumOfTrials,
                                                   TST_InitialCtrlAuth,
                                                   &TST_PasswordAuthHandle,
                                                   TST_Workspace,
                                                   TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"7 SST_AuthenticatorPasswordCreate ",
                                 TestName,
                                 TestName);


      /*8. Close the transaction */
      /*-----------------------*/
      TST_Status = SST_TransactionEnd(TST_TransactionId, DX_TRUE, TST_Workspace, TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"8. SST_TransactionEnd",
                                 TestName,
                                 TestName);


      /*9 Open the  password authentication */
      /*-------------------------------------*/
      TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                          TST_PasswordAuthHandle,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                          TST_NO_CHALLENGE,
                                          TST_Workspace,
                                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"9. SST_AuthenticationOpen ",
                                 TestName,
                                 TestName);


      /* 10. Open a transaction for operations */
      /*-----------------------------------*/
      TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"10.SST_TransactionStart",
                                 TestName,
                                 TestName);


    TST_NewUsedSizeInBytesMain =1000;
    TST_maxSizeInBytesMainIn =TST_NewUsedSizeInBytesMain + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES;



    
   
   /*11.Get current size and set MainFile to AES key size + overhead + current
        Insert AES key -> generate AES key (fail) -> delete AES key from DB ->
        Generate AES Key (This test to check deleted list)*/
   /*--------------------------------------------------------------------------*/
   for( i = 0 ; i < 3 ; ++i, ++k )
   {
       KeyHandle.objId = k;
      
       /*7.a Get current - Main  */
       TST_Status = SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_MainDBFileHandle,
                                       &TST_maxSizeInBytesMain,
                                       &TST_CurrUsedSizeInBytesMain);

       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"11.a Get current - Main",
                                               TestName,
                                               TestName); 


       


       /*11.b Set max size - Main */
       TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,
           (TST_CurrUsedSizeInBytesMain + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES + keyDataSize[i]));
       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"11.b Set max size - Main",
                                               TestName,
                                               TestName);

 

       
       /*11.c Insert first AES Key */
       TST_Status = SST_AESKeyInsert(   TST_TransactionId,
                                       TST_SessionId,
                                       TST_PasswordAuthHandle,                                                               
                                       buf,
                                       (SSTAESKeyType_t)i,
                                       TST_AESKeyDataType,
                                       &KeyHandle,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"11.c Insert first AES Key",
                                               TestName,
                                               TestName);


      
       /*11.d Generate AES key (fail)*/
       TST_Status = SST_AESKeyGenerate( TST_TransactionId,
                                       TST_SessionId,
                                       TST_PasswordAuthHandle,                                
                                       (SSTAESKeyType_t)i,
                                       TST_AESKeyDataType,
                                       &KeyHandle,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes); 

   
       if(TST_Status == SST_RC_ERROR_NVS_MAIN_MAX_SIZE_EXCEEDED)
          TST_Status = TESTPASS;
       else 
          TST_Status = TESTFAIL;
           
       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"11.d Generate AES key (fail)",
                                               TestName,
                                               TestName);



       /*11.e delete AES key*/
       TST_Status = SST_DataDelete( TST_TransactionId,
                                   TST_SessionId,  
                                   KeyHandle,
                                   TST_Workspace,
                                   TST_WorkspaceSizeInBytes);
       TST_ATP_CHECK_ERROR_RETURN(  TST_Status,"11.e delete AES key",
                                               TestName,
                                               TestName);


      
       /*11.f generate AES key*/
       TST_Status = SST_AESKeyGenerate( TST_TransactionId,
                                       TST_SessionId,
                                       TST_PasswordAuthHandle,                                
                                       (SSTAESKeyType_t)i,
                                       TST_AESKeyDataType,
                                       &KeyHandle,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);
       TST_ATP_CHECK_ERROR_RETURN(  TST_Status,"11.f generate AES key",
                                               TestName,
                                               TestName);


   }

   /*12.Get current size and set MainFile to AES key size + overhead + current
   Insert AES key -> Insert AES key (fail) -> delete AES key from DB ->
   Insert AES key (This test to check deleted list)*/
   /*--------------------------------------------------------------------------*/

   for( i = 0 ; i < 3 ; ++i )
   {
       KeyHandle.objId = i;
       
       /*12.a Get current - Main*/  
       TST_Status = SST_UtilNVSSizesGet((DxNvsMemoryId_t)TST_MainDBFileHandle,
                                       &TST_maxSizeInBytesMain,
                                       &TST_CurrUsedSizeInBytesMain);
       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"12.a Get current - Main",
                                               TestName,
                                               TestName);


       
       /*12.b Set max size - Main*/
       TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,
           (TST_CurrUsedSizeInBytesMain + SST_NVS_MAIN_OVERHEAD_SIZE_IN_BYTES + keyDataSize[i]));
       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"12.b Set max size - Main",
                                               TestName,
                                               TestName); 

       
       /*12.c Insert first AES Key */
       TST_Status = SST_AESKeyInsert(   TST_TransactionId,
                                       TST_SessionId,
                                       TST_PasswordAuthHandle,                                                               
                                       buf,
                                       (SSTAESKeyType_t)i,
                                       TST_AESKeyDataType,
                                       &KeyHandle,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);
       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"12.c Insert first AES Key ",
                                               TestName,
                                               TestName);


       
       /*12.d Insert second AES Key (fail)*/
       TST_Status = SST_AESKeyInsert(   TST_TransactionId,
                                       TST_SessionId,
                                       TST_PasswordAuthHandle,                                                               
                                       buf,
                                       (SSTAESKeyType_t)i,
                                       TST_AESKeyDataType,
                                       &KeyHandle,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes); 

       if(TST_Status == SST_RC_ERROR_NVS_MAIN_MAX_SIZE_EXCEEDED)
           TST_Status = TESTPASS;
       else 
           TST_Status = TESTFAIL;
       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"12.d Insert second AES Key (fail)",
                                               TestName,
                                               TestName);


       /* 12.e delete AES key */
       TST_Status = SST_DataDelete( TST_TransactionId,
                                   TST_SessionId,  
                                   KeyHandle,
                                   TST_Workspace,
                                   TST_WorkspaceSizeInBytes);
       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"12.e delete AES key",
                                               TestName,
                                               TestName);


       
       
       /*12.f Insert AES key*/
       TST_Status = SST_AESKeyInsert(   TST_TransactionId,
                                       TST_SessionId,
                                       TST_PasswordAuthHandle,                                                               
                                       buf,
                                       (SSTAESKeyType_t)i,
                                       TST_AESKeyDataType,
                                       &KeyHandle,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);
       TST_ATP_CHECK_ERROR_RETURN(TST_Status,"12.f Insert AES key",
                                               TestName,
                                               TestName);


    


   } 
   
    /*13.Set the max Size of both DB to 0x7ffffff0*/
    /*--------------------------------------------*/

    TST_maxSizeInBytesMainIn = 0x7ffffff0;

    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_MainDBFileHandle,TST_maxSizeInBytesMainIn);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"13. SST_UtilNVSMaxSizeSet - TST_MainDBFileHandle -  0x7ffffff0",
                                          TestName,
                                          TestName);


    TST_Status = SST_UtilNVSMaxSizeSet((DxNvsMemoryId_t)TST_SecondaryDBFileHandle,TST_maxSizeInBytesMainIn);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"13. SST_UtilNVSMaxSizeSet - TST_SecondaryDBFileHandle -  0x7ffffff0",
                                          TestName,
                                          TestName);


    
    /* 14.Delete the session */
    /*-----------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"14. SST_SessionDelete", TestName, TestName);



    /*15. Close the transaction */
    /*--------------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
        DX_TRUE,/*reflash sensitive*/
        TST_Workspace,
        TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"15. SST_TransactionEnd",
        TestName,
        TestName);



   return TST_Status;

   EXIT_ON_ERROR:
 
    return DX_FAILURE;
 

}
/****************************************************************
* Function Name:
* SST_TST_ATP_UtilityHandle
*
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
* Test the handle build and handle type retrieval
*
* Algorithm:
* 1.  Create a new session by calling SST_SessionCreate.
* 2.  Open a transaction by calling SST_TransactionStart.
* 3.  Create a new  password authenticator
* 4.  Close the transaction
* 5.  Open the  password authentication 
* 6.  Open a transaction for operations
* 7.  Insert a new data object by calling SST_InsertData with a user defined handle.
* 8.  Build a handle by calling SST_DataHandleBuild
* 9.  Read a data object using this handle by calling SST_DataRead.
* 10. Validate this is the same data by comparing the retrieved data with the inserted data
* 11. Validate the handle type by calling SST_DataTypeGet.
* 12. Delete the data by calling SST_DeleteData.
* 13. Delete the pass Authenticator
* 14. Close the transaction by calling SST_TransactionClose.
* 15. Delete the session by calling SST_SessionDelete.
********************************************************************************/
DxError_t SST_TST_ATP_UtilityHandle ( void )
{
    /********* TST Variables initialization *********/
    SSTTxnId_t         TST_TransactionId;
    SSTSessionId_t     TST_SessionId;
    SSTDataType_t      TST_aDataType;
    SSTDataType_t      TST_aDataTypeOut;
    SSTObjectId_t      TST_aDataObjID;
    SSTHandle_t        TST_aDataHandle;
    SSTHandle_t        TST_BuiltaDataHandle;
    DxByte_t           TST_Data[] = {0x01,0x02,0x03};
    DxByte_t           TST_DataOut[UTIL_DATA_SIZE];
    DxUint32_t         TST_DataSize = UTIL_DATA_SIZE;
    SSTHandle_t        TST_PasswordAuthHandle, TST_InitialCtrlAuth;
    DxChar             * TestName = "ATP test SST Utility Handle";
    DxError_t          TST_Status = DX_FAILURE;

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** SST_TST_ATP_UtilityHandle Tests ******************* \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    TST_aDataType = 0x33;
    TST_aDataObjID = TST_aDataHandle.objId = 0x4455;
    

    
    /* Create a session for operations */
    /*---------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                                          TestName,
                                          TestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                                          TestName,
                                          TestName);

      /* Create a new  password authenticator */
      /*--------------------------------------*/
      TST_InitialCtrlAuth.objDigest = 0;
      TST_InitialCtrlAuth.objId = SST_CLOSE_AUTH_HANDLE;
      TST_PasswordAuthHandle.objDigest = 0;
      TST_PasswordAuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
      TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                   TST_SessionId, 
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                                   TST_ATP_PassAuthObjectTestData[0].TST_MasterMaxNumOfTrials,
                                                   TST_InitialCtrlAuth,
                                                   &TST_PasswordAuthHandle,
                                                   TST_Workspace,
                                                   TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate ",
                                 TestName,
                                 TestName);


      /* Close the transaction */
      /*-----------------------*/
      TST_Status = SST_TransactionEnd(TST_TransactionId, DX_TRUE, TST_Workspace, TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                                 TestName,
                                 TestName);


      /* Open the  password authentication */
      /*-----------------------------------------*/
      TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                          TST_PasswordAuthHandle,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPassword,
                                          TST_ATP_PassAuthObjectTestData[0].TST_MasterPasswordSizeInBytes,
                                          TST_NO_CHALLENGE,
                                          TST_Workspace,
                                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen ",
                                 TestName,
                                  TestName);


      /* Open a transaction for operations */
      /*-----------------------------------*/
      TST_Status = SST_TransactionStart(&TST_TransactionId);
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                                 TestName,
                                 TestName);





    /* Insert a new Data object */
    /*--------------------------*/
    TST_Status = SST_DataInsert(TST_TransactionId,
                               TST_SessionId,
                               TST_PasswordAuthHandle,
                               TST_Data,
                               TST_DataSize,
                               DX_TRUE,
                               TST_aDataType,
                               &TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert",
                                          TestName,
                                          TestName);


    /*Build a handle*/
    /*--------------*/
    TST_Status = SST_DataHandleBuild(TST_aDataType,TST_aDataObjID,&TST_BuiltaDataHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataHandleBuild",
                                          TestName,
                                          TestName);

   
   /* Read the data */
   /*---------------*/
    TST_Status = SST_DataRead(TST_SessionId,
                             TST_BuiltaDataHandle,
                             0,
                             TST_DataOut,
                             &TST_DataSize,
                             TST_Workspace,
                             TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataRead",
                                          TestName,
                                          TestName);

   
    /* Compare the retrieved data to the original */
    /*--------------------------------------------*/
    if(!DX_VOS_MemCmp(TST_Data,TST_DataOut,TST_DataSize))
          TST_Status = TESTPASS; /*Data Buffers are the same*/
     else
           TST_Status = TESTFAIL; /*Data Buffers are different*/
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Original data",
                                          TestName,
                                          TestName);


    /*Validate the handle type*/
    /*------------------------*/
    TST_Status = SST_DataTypeGet(TST_aDataHandle,&TST_aDataTypeOut);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataTypeGet",
                                          TestName,
                                          TestName);


    if(TST_aDataTypeOut != TST_aDataType)
      TST_Status = TESTFAIL;
    else
      TST_Status = TESTPASS;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_aDataTypeOut",
                                          TestName,
                                          TestName);


    /*Delete the data*/
    /*---------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                               TST_SessionId,
                               TST_aDataHandle,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete",
                                          TestName,
                                          TestName);



    /*Delete the pass Authenticator*/
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,TST_PasswordAuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete", TestName, TestName);



    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                   DX_TRUE,/*reflash sensitive*/
                                   TST_Workspace,
                                   TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                                          TestName,
                                          TestName);


    /* Delete the session */
    /*--------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                                          TestName,
                                          TestName);



   return TST_Status;

   EXIT_ON_ERROR:
 
   return DX_FAILURE;
  

}
